/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.gunfireoverhaul;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        public final Ambient ambient;

        Common(ForgeConfigSpec.Builder builder) {
            this.ambient = new Ambient(builder);
        }

        public static class Ambient {
            public final ForgeConfigSpec.BooleanValue enableAmbientGunfire;
            public final ForgeConfigSpec.IntValue minTimeBetweenShots;
            public final ForgeConfigSpec.IntValue maxTimeBetweenShots;
            public final ForgeConfigSpec.IntValue minGunfireDistance;
            public final ForgeConfigSpec.IntValue maxGunfireDistance;
            public final Scenarios scenarios;
            public final PowerTiers powerTiers;
            public final SoundTypes soundTypes;

            Ambient(ForgeConfigSpec.Builder builder) {
                builder.comment("Settings for the ambient gunfire system, creating a 'battlefield' atmosphere.").push("Ambient");
                this.enableAmbientGunfire = builder.comment("Globally enables or disables the ambient gunfire sound system.").define("enableAmbientGunfire", true);
                this.minTimeBetweenShots = builder.comment("Minimum time in ticks between ambient gunfire events (20 ticks = 1 second).").defineInRange("minTimeBetweenShots", 1200, 100, 72000);
                this.maxTimeBetweenShots = builder.comment("Maximum time in ticks between ambient gunfire events.").defineInRange("maxTimeBetweenShots", 6000, 200, 72000);
                this.minGunfireDistance = builder.comment("Minimum distance in blocks from the player where an ambient sound can originate.").defineInRange("minGunfireDistance", 501, 100, 10000);
                this.maxGunfireDistance = builder.comment("Maximum distance in blocks from the player where an ambient sound can originate.").defineInRange("maxGunfireDistance", 5001, 200, 10000);
                this.scenarios = new Scenarios(builder);
                this.powerTiers = new PowerTiers(builder);
                this.soundTypes = new SoundTypes(builder);
                builder.pop();
            }

            public static class Scenarios {
                public final ForgeConfigSpec.IntValue singleShotWeight;
                public final ForgeConfigSpec.IntValue burstFireWeight;
                public final ForgeConfigSpec.IntValue fullAutoWeight;
                public final ForgeConfigSpec.IntValue minBurstShots;
                public final ForgeConfigSpec.IntValue maxBurstShots;
                public final ForgeConfigSpec.IntValue minTimeBetweenBurstShots;
                public final ForgeConfigSpec.IntValue maxTimeBetweenBurstShots;
                public final ForgeConfigSpec.IntValue minFullAutoShots;
                public final ForgeConfigSpec.IntValue maxFullAutoShots;
                public final ForgeConfigSpec.IntValue timeBetweenFullAutoShots;

                Scenarios(ForgeConfigSpec.Builder builder) {
                    builder.comment(new String[]{"\nConfiguration for different ambient event scenarios.", "The chance for a scenario is (its_weight / sum_of_all_scenario_weights)."}).push("Scenarios");
                    this.singleShotWeight = builder.comment("Weight for a standard, single shot event.").defineInRange("singleShotWeight", 70, 0, 1000);
                    this.burstFireWeight = builder.comment("Weight for a 'Burst Fire' event (a series of shots).").defineInRange("burstFireWeight", 20, 0, 1000);
                    this.fullAutoWeight = builder.comment("Weight for a 'Full Auto' event (a rapid succession of shots).").defineInRange("fullAutoWeight", 10, 0, 1000);
                    builder.comment("\nSettings for the 'Burst Fire' scenario.").push("BurstFire");
                    this.minBurstShots = builder.defineInRange("minBurstShots", 2, 2, 10);
                    this.maxBurstShots = builder.defineInRange("maxBurstShots", 5, 2, 20);
                    this.minTimeBetweenBurstShots = builder.defineInRange("minTimeBetweenBurstShots", 5, 2, 100);
                    this.maxTimeBetweenBurstShots = builder.defineInRange("maxTimeBetweenBurstShots", 20, 5, 200);
                    builder.pop();
                    builder.comment("\nSettings for the 'Full Auto' scenario.").push("FullAuto");
                    this.minFullAutoShots = builder.defineInRange("minFullAutoShots", 5, 3, 30);
                    this.maxFullAutoShots = builder.defineInRange("maxFullAutoShots", 15, 5, 50);
                    this.timeBetweenFullAutoShots = builder.comment("The fixed time in ticks between each shot in a full-auto burst.").defineInRange("timeBetweenFullAutoShots", 2, 1, 20);
                    builder.pop();
                    builder.pop();
                }
            }

            public static class PowerTiers {
                public final ForgeConfigSpec.IntValue tier1_weight;
                public final ForgeConfigSpec.IntValue tier2_weight;
                public final ForgeConfigSpec.IntValue tier3_weight;
                public final ForgeConfigSpec.IntValue tier4_weight;
                public final ForgeConfigSpec.IntValue tier5_weight;

                PowerTiers(ForgeConfigSpec.Builder builder) {
                    builder.comment(new String[]{"\nWeighted chances for shot power tiers.", "The chance for a tier is (its_weight / sum_of_all_weights). Set a weight to 0 to disable that tier."}).push("Power_Tiers_Weight");
                    this.tier1_weight = builder.comment("Weight for 'Pistol/SMG' (Power 1-4)").defineInRange("tier1_weight", 50, 0, 1000);
                    this.tier2_weight = builder.comment("Weight for 'Assault Rifle' (Power 5-15)").defineInRange("tier2_weight", 25, 0, 1000);
                    this.tier3_weight = builder.comment("Weight for 'Battle Rifle' (Power 16-40)").defineInRange("tier3_weight", 15, 0, 1000);
                    this.tier4_weight = builder.comment("Weight for 'Sniper Rifle' (Power 41-80)").defineInRange("tier4_weight", 8, 0, 1000);
                    this.tier5_weight = builder.comment("Weight for 'Heavy Caliber' (Power 81+)").defineInRange("tier5_weight", 2, 0, 1000);
                    builder.pop();
                }
            }

            public static class SoundTypes {
                public final ForgeConfigSpec.BooleanValue enableSurfaceSounds;

                SoundTypes(ForgeConfigSpec.Builder builder) {
                    builder.comment("\nEnable or disable specific types of ambient sound environments.").push("Sound_Types");
                    this.enableSurfaceSounds = builder.comment("Surface: A clear gunshot sound in an open area.").define("enableSurfaceSounds", true);
                    builder.pop();
                }
            }
        }
    }
}

